/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.morph;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.util.fst.FST;

public abstract class TokenInfoFST {
    protected final FST<Long> fst;
    private final int cacheCeiling;
    private final int cacheFloor;
    private final FST.Arc<Long>[] rootCache;
    public final Long NO_OUTPUT;

    protected TokenInfoFST(FST<Long> fst, int cacheCeiling, int cacheFloor) throws IOException {
        if (cacheCeiling < cacheFloor) {
            throw new IllegalArgumentException("cacheCeiling must be larger than cacheFloor; cacheCeiling=" + cacheCeiling + ", cacheFloor=" + cacheFloor);
        }
        this.fst = fst;
        this.cacheCeiling = cacheCeiling;
        this.cacheFloor = cacheFloor;
        this.NO_OUTPUT = (Long)fst.outputs.getNoOutput();
        this.rootCache = this.cacheRootArcs();
    }

    private FST.Arc<Long>[] cacheRootArcs() throws IOException {
        FST.Arc[] rootCache = new FST.Arc[1 + (this.cacheCeiling - this.cacheFloor)];
        FST.Arc firstArc = new FST.Arc();
        this.fst.getFirstArc(firstArc);
        FST.Arc arc = new FST.Arc();
        FST.BytesReader fstReader = this.fst.getBytesReader();
        for (int i = 0; i < rootCache.length; ++i) {
            if (this.fst.findTargetArc(this.cacheFloor + i, firstArc, arc, fstReader) == null) continue;
            rootCache[i] = new FST.Arc().copyFrom(arc);
        }
        return rootCache;
    }

    public FST.Arc<Long> findTargetArc(int ch, FST.Arc<Long> follow, FST.Arc<Long> arc, boolean useCache, FST.BytesReader fstReader) throws IOException {
        if (useCache && ch >= this.cacheFloor && ch <= this.cacheCeiling) {
            assert (ch != -1);
            FST.Arc<Long> result = this.rootCache[ch - this.cacheFloor];
            if (result == null) {
                return null;
            }
            arc.copyFrom(result);
            return arc;
        }
        return this.fst.findTargetArc(ch, follow, arc, fstReader);
    }

    public FST.Arc<Long> getFirstArc(FST.Arc<Long> arc) {
        return this.fst.getFirstArc(arc);
    }

    public FST.BytesReader getBytesReader() {
        return this.fst.getBytesReader();
    }
}

